package com.ethon.plugin;

import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

import com.ethon.DataBase;
import com.ethon.mode.DataPoint;
import com.ethon.tools.CoordTransfer;
import com.ethon.tools.CounterUtil;
import com.ethon.tools.ImageGenerator;
import com.ethon.ui.DataField;
import com.ethon.ui.IntTextField;

/**
 * ԷɵSpatial Neighborhood Clustering㷨ĸĽ汾
 * SNC2ԭʼ汾SNC㷨һƫֵжϾıԵӶܹЧش
 * ⣬SNC2ֵԴڽ沿ֵؽоĺϲ 㷨ΪĲֱǣ 1ʼ 2ֲֵȷ
 * 3һƫֵÿ 4û趨ֵоĺϲ
 * 
 * @author ethonchan@gmail.com
 * 
 */
public class SNC2 {
	private Frame parent;
	// ݿռÿάȻֵĿ
	private int K;
	// 㷨ݵСֵx,yԼĿ
	private double dx, dy, xmin, ymin;
	// ݳӰӣ趨ΪMax(dx,dy)
	private double sigma;
	// ֺ
	private Grid[][] grids;
	// 㷨ҵľ
	List<SCluster> cls;

	/**
	 * ûָĻĿݿռ仮Ϊһ񣬲ҽеݷ䵽
	 * 
	 * @param K
	 *            ݿռÿάȻֵĿ
	 */
	public SNC2(Frame parent, int K) {
		this.parent=parent;
		this.K = K;
	}

	public void process() {
		// ʼ
		initializeGrids();

		// ֲֵҳ
		cls = new ArrayList<SCluster>();
		for (int x = 0, clusterNumber = 1; x < K; x++) {
			for (int y = 0; y < K; y++) {
				if (isLocalMax(x, y))
					cls.add(new SCluster(x, y, clusterNumber++));
			}
		}

		// ÿ
		for (int i = 0, len = cls.size(); i < len; i++) {
			SCluster cluster = cls.get(i);
			cluster = searchCluster(cluster);
			cls.set(i, cluster);
		}
		// û趨ֵоĺϲ
		mergeCluster();


		// ׼ͼ
		BufferedImage img = ImageGenerator.drawImage(null, DataBase.sLen);
		img = showCoord(img);
		Graphics g = img.getGraphics();
		CoordTransfer tsf = new CoordTransfer();

		DataPoint[] points = DataBase.getInstance().getPoints();
		g.setColor(Color.gray);
		for (DataPoint point : points) {
			int[] coord = tsf.getPanelCoord(point.getCoord_X(),
					point.getCoord_Y());
			g.fillOval(coord[0] - 1, coord[1] - 1, 2, 2);
		}

		for (int i = 0, len = cls.size(); i < len; i++) {
			SCluster c = cls.get(i);
			float t = (float) c.clusterNumber / (float) cls.size();
			Color color = CounterUtil.HLStoRGB(t, (float) 0.5, (float) 0.5);
			c.color = color;
		}

		// Ϣ
		for (SCluster cluster : cls) {
			List<Coord> content = cluster.contentList;

			g.setColor(cluster.color);
			for (Coord gnumber : content) {
				int x = gnumber.getX();
				int y = gnumber.getY();

				Grid grid = grids[x][y];
				ArrayList<DataPoint> list = grid.list;

				for (DataPoint point : list) {
					int[] coord = tsf.getPanelCoord(point.getCoord_X(),
							point.getCoord_Y());
					g.fillOval(coord[0] - 1, coord[1] - 1, 2, 2);
				}
			}
		}

		for (SCluster cluster : cls) {
			g.setColor(Color.black);
			Coord c = cluster.center;
			int x = c.getX();
			int y = c.getY();
			double xloc = xmin + dx / 2 + dx * x;
			double yloc = ymin + dy / 2 + dy * y;
			int[] coord = tsf.getPanelCoord(xloc, yloc);
			g.fillOval(coord[0] - 8, coord[1] - 8, 16, 16);
			g.setFont(new Font("SansSerif", Font.BOLD, 25));
			g.drawString(Integer.toString(cluster.clusterNumber), coord[0],
					coord[1]);
		}

		g.dispose();

		DataField.updateImagePanel(img);

	}

	private BufferedImage showCoord(BufferedImage img) {
		CoordTransfer tsf = new CoordTransfer();
		Graphics g = img.getGraphics();
		g.setColor(Color.black);
		// xֵyֵ
		int[] len = tsf.getPanelCoord(xmin + dx * K, ymin + dy * K);

		// 
		for (int y = 0; y <= K; y++) {
			double yloc = ymin + dy * y;
			int[] coord = tsf.getPanelCoord(xmin, yloc);

			g.drawLine(coord[0], coord[1], len[0], coord[1]);
		}

		// ݵ
		for (int x = 0; x <= K; x++) {
			double xloc = xmin + dx * x;
			int[] coord = tsf.getPanelCoord(xloc, ymin);

			g.drawLine(coord[0], coord[1], coord[0], len[1]);
		}

		g.dispose();
		return img;
	}

	/**
	 * ľذ
	 * 
	 * @param cluster
	 *            ɾǵľ
	 * @return ľ
	 */
	public SCluster searchCluster(SCluster cluster) {
		List<Coord> list = cluster.contentList;
		while (true) {
			List<Coord> upDown = checkUpAndDown(cluster);
			for (Coord c : upDown) {
				if (!list.contains(c))
					list.add(c);
			}
			upDown.clear();

			List<Coord> leftRight = checkLeftAndRight(cluster);
			if (leftRight.size() == 0)
				break;

			for (Coord c : leftRight) {
				if (!list.contains(c))
					list.add(c);
			}
			leftRight.clear();
		}

		return cluster;
	}

	/**
	 * û趨ֵоĺϲΪ 1ͳƱClusterǵܶϢ 2ûֵָ
	 * 3˵񣬲Һϲ
	 * 
	 */
	public void mergeCluster() {
		int[] staAll = getStatisticsOfClusters();
		int[] staIts = getStatisticsOfIntersection();

		String msg ="<html><pre>"
				+ "   ھеͳƽ<br/>"
				+ "      min = " + staAll[0] + ", "+ "max = " + staAll[1] + "<br />"
				+ "      sum = " + staAll[2] + ", "+ "avg = " + staAll[3] + "<br />"
				+ "   оеĽͳƽ<br/>"
				+ "      min = " + staIts[0] + ", "+ "max = " + staIts[1] + "<br />" 
				+ "      sum = " + staIts[2] + ", "+ "avg = " + staIts[3]
				+ "</pre></html>";

		StatisInfoDialog dialog=new StatisInfoDialog(parent,msg);
		int thread = dialog.getValue();

		// Ƴܶȵthread
		for (int i = 0, len = cls.size(); i < len; i++) {
			SCluster cluster = cls.get(i);
			List<Coord> clist = cluster.contentList;
			List<Coord> slist = new LinkedList<Coord>();
			for (Coord ci : clist) {
				int x = ci.getX();
				int y = ci.getY();
				int den = grids[x][y].getPnumber();

				if (den >= thread)
					slist.add(new Coord(x, y));
			}
			cluster.contentList = slist;
			cls.set(i, cluster);
		}

		// ϲڽ沿ֵ
		for (int i1 = 0, len = cls.size(); i1 < len; i1++) {
			SCluster cluster1 = cls.get(i1);
			for (int i2 = i1 + 1; i2 < len; i2++) {
				SCluster cluster2 = cls.get(i2);
				List<Coord> its = getIntersection(cluster1, cluster2);
				if (its.size() > 0) {
					List<Coord> list1 = cluster1.contentList;
					List<Coord> list2 = cluster2.contentList;
					for (Coord l : list1) {
						if (!list2.contains(l))
							list2.add(l);
					}
					cluster1.contentList.clear();
					cls.set(i1, cluster1);
					cls.set(i2, cluster2);
					break;
				}
			}
		}

		List<SCluster> result = new ArrayList<SCluster>();
		int clusterNumber = 1;
		for (SCluster cluster : cls) {
			if (cluster.contentList.size() == 0)
				continue;
			cluster.clusterNumber = clusterNumber;
			clusterNumber++;
			result.add(cluster);
		}
		cls = result;
	}

	/**
	 * бܶͳ
	 * 
	 * @return ͳƽ{СܶȣܶȣܶȺͣ}
	 */
	private int[] getStatisticsOfClusters() {
		int minDen = Integer.MAX_VALUE;
		int maxDen = Integer.MIN_VALUE;
		int allDen = 0;
		int num = 0;

		for (SCluster cluster : cls) {
			List<Coord> clist = cluster.contentList;
			for (Coord ci : clist) {
				int x = ci.getX();
				int y = ci.getY();
				int den = grids[x][y].getPnumber();

				if (minDen > den)
					minDen = den;
				if (maxDen < den)
					maxDen = den;
				allDen += den;
				num++;
			}
		}
		if(minDen==Integer.MAX_VALUE)	minDen=0;
		if(maxDen==Integer.MIN_VALUE)	maxDen=-1;
		return new int[] { minDen, maxDen, allDen, num };
	}

	/**
	 * 沿ֵܶͳ
	 * 
	 * @return ͳƽ{СܶȣܶȣܶȺͣ}
	 */
	private int[] getStatisticsOfIntersection() {
		// нܶͳ
		int minDen = Integer.MAX_VALUE;
		int maxDen = Integer.MIN_VALUE;
		int allDen = 0;
		int num = 0;
		List<Coord> its = getIntersection();
		for (Coord it : its) {
			int x = it.getX();
			int y = it.getY();
			int den = grids[x][y].getPnumber();

			if (minDen > den)
				minDen = den;
			if (maxDen < den)
				maxDen = den;
			allDen += den;
			num++;
		}
		if(minDen==Integer.MAX_VALUE)	minDen=0;
		if(maxDen==Integer.MIN_VALUE)	maxDen=-1;
		return new int[] { minDen, maxDen, allDen, num };
	}

	/**
	 * SClusterĽ
	 * 
	 * @return SClusterĽ
	 */
	private List<Coord> getIntersection() {
		List<Coord> result = new LinkedList<Coord>();
		for (int i1 = 0, len = cls.size(); i1 < len; i1++) {
			SCluster cluster1 = cls.get(i1);
			for (int i2 = i1 + 1; i2 < len; i2++) {
				SCluster cluster2 = cls.get(i2);
				List<Coord> tp = getIntersection(cluster1, cluster2);
				for (Coord t : tp) {
					if (!result.contains(t))
						result.add(t);
				}
			}
		}
		return result;
	}

	/**
	 * SClusterĽ
	 * 
	 * @param cluster1
	 *            һSCluster
	 * @param cluster2
	 *            ڶSCluster
	 * @return SClusterĽ
	 */
	private List<Coord> getIntersection(SCluster cluster1, SCluster cluster2) {
		List<Coord> list1 = cluster1.contentList;
		List<Coord> list2 = cluster2.contentList;
		List<Coord> result = new LinkedList<Coord>();
		for (Coord i1 : list1) {
			for (Coord i2 : list2) {
				if (i1 == i2)
					result.add(i1);
			}
		}
		return result;
	}

	/**
	 * ·ľ
	 * 
	 * @param cluster
	 *            δľ
	 * @return ǰ·
	 */
	private List<Coord> checkUpAndDown(SCluster cluster) {
		List<Coord> list = cluster.contentList;
		List<Coord> result = new LinkedList<Coord>();

		for (Coord gnumber : list) {
			int x = gnumber.getX();
			int y = gnumber.getY();

			boolean flag = true;
			while (flag) {
				flag = checkUpGrid(x, y, list, result);
				y--;
			}

			y = gnumber.getY();
			flag = true;
			while (flag) {
				flag = checkDownGrid(x, y, list, result);
				y++;
			}
		}
		return result;
	}

	/**
	 * ҷľ
	 * 
	 * @param cluster
	 *            δľ
	 * @return ǰҷ
	 */
	List<Coord> checkLeftAndRight(SCluster cluster) {
		List<Coord> list = cluster.contentList;
		List<Coord> result = new LinkedList<Coord>();

		for (Coord gnumber : list) {
			int x = gnumber.getX();
			int y = gnumber.getY();

			boolean flag = true;
			while (flag) {
				flag = checkLeftGrid(x, y, list, result);
				x--;
			}

			x = gnumber.getX();
			flag = true;
			while (flag) {
				flag = checkRightGrid(x++, y, list, result);
				x++;
			}
		}
		return result;
	}

	/**
	 * ϷgridϷgridYƫֵڵǰYƫֵͷtrue򷵻false
	 * 
	 * @param x
	 *            ǰX
	 * @param y
	 *            ǰY
	 * @param list
	 *            ǰб
	 * @return ϷǷ
	 */
	private boolean checkUpGrid(int x, int y, List<Coord> list,
			List<Coord> result) {
		if (y == 0)
			return false;

		if (grids[x][y].getYdp() > grids[x][y - 1].getYdp())
			return false;
		Coord coord = new Coord(x, y - 1);

		if (!list.contains(coord) && !result.contains(coord))
			result.add(coord);
		return true;
	}

	/**
	 * ·grid·gridYƫֵСڵǰYƫֵͷtrue򷵻false
	 * 
	 * @param x
	 *            ǰX
	 * @param y
	 *            ǰY
	 * @param list
	 *            ǰб
	 * @return ·Ƿ
	 */
	private boolean checkDownGrid(int x, int y, List<Coord> list,
			List<Coord> result) {
		if (y == K - 1)
			return false;

		if (grids[x][y].getYdp() < grids[x][y + 1].getYdp())
			return false;
		Coord coord = new Coord(x, y + 1);
		if (!list.contains(coord) && !result.contains(coord))
			result.add(coord);
		return true;
	}

	/**
	 * 󷽵grid󷽵gridXƫֵڵǰXƫֵͷtrue򷵻false
	 * 
	 * @param x
	 *            ǰX
	 * @param y
	 *            ǰY
	 * @param list
	 *            ǰб
	 * @return 󷽵Ƿ
	 */
	private boolean checkLeftGrid(int x, int y, List<Coord> list,
			List<Coord> result) {
		if (x == 0)
			return false;

		if (grids[x][y].getXdp() > grids[x - 1][y].getXdp())
			return false;

		Coord coord = new Coord(x - 1, y);
		if (!list.contains(coord) && !result.contains(coord))
			result.add(coord);
		return true;
	}

	/**
	 * ҷgridҷgridXƫֵСڵǰXƫֵͷtrue򷵻false
	 * 
	 * @param x
	 *            ǰX
	 * @param y
	 *            ǰY
	 * @param list
	 *            ǰб
	 * @return ҷǷ
	 */
	private boolean checkRightGrid(int x, int y, List<Coord> list,
			List<Coord> result) {
		if (x == K - 1)
			return false;

		if (grids[x][y].getXdp() < grids[x + 1][y].getXdp())
			return false;

		Coord coord = new Coord(x + 1, y);
		if (!list.contains(coord) && !result.contains(coord))
			result.add(coord);

		return true;
	}

	/**
	 * ΪgridXgridYǷоֲֵ
	 * 
	 * @param gridX
	 *            x
	 * @param gridY
	 *            y
	 * @return оֲֵ򷵻true֮false
	 */
	private boolean isLocalMax(int gridX, int gridY) {
		Grid[] ngb = getNeighborGrids(gridX, gridY);
		double pot = grids[gridX][gridY].getPotential();

		for (Grid g : ngb) {
			if (g.getPotential() > pot)
				return false;
		}

		return true;
	}

	/**
	 * ÿһƫֵ
	 */
	public void initializeGrids() {
		grids = new Grid[K][K];

		DataPoint[] points = DataBase.getInstance().getPoints();
		// ҳݵСȡֵݴȷÿı䳤dx dy
		xmin = Double.MAX_VALUE;
		ymin = Double.MAX_VALUE;
		double xmax = Double.MIN_VALUE;
		double ymax = Double.MIN_VALUE;

		for (DataPoint p : points) {
			double x = p.getCoord_X();
			double y = p.getCoord_Y();

			if (xmin > x)
				xmin = x;
			if (ymin > y)
				ymin = y;

			if (xmax < x)
				xmax = x;
			if (ymax < y)
				ymax = y;
		}
		dx = (xmax - xmin) / K;
		dy = (ymax - ymin) / K;

		// 趨ݳӰ
		sigma = Math.max(dx, dy);

		// ÿݵ䵽ӦУעпһΪ
		for (DataPoint p : points) {
			double x = p.getCoord_X();
			double y = p.getCoord_Y();

			int xl = (int) Math.floor((x - xmin) / dx);
			int yl = (int) Math.floor((y - ymin) / dy);
			if (xl == K)
				xl = K - 1;
			if (yl == K)
				yl = K - 1;
			if (grids[xl][yl] == null)
				grids[xl][yl] = new Grid();

			grids[xl][yl].addDataPoint(p);
		}

		// ȷûпյ
		for (int x = 0; x < K; x++) {
			for (int y = 0; y < K; y++) {
				Grid grid = grids[x][y];
				if (grid == null) {
					double xloc = xmin + dx / 2 + dx * x;
					double yloc = ymin + dy / 2 + dy * y;

					grid = new Grid();
					grid.setCenter(xloc, yloc);
					grids[x][y] = grid;
				}
			}
		}

		// ÿֵһƫֵ
		double sigma2 = sigma * sigma;
		for (int x = 0; x < K; x++) {
			for (int y = 0; y < K; y++) {
				double xloc = grids[x][y].getXCenter();
				double yloc = grids[x][y].getYCenter();
				double pot = 0;
				double xdp = 0;
				double ydp = 0;
				for (int xi = 0; xi < K; xi++) {
					for (int yi = 0; yi < K; yi++) {
						Grid gi = grids[xi][yi];
						if (gi.getPnumber() == 0)
							continue;

						double xdist = gi.getXCenter() - xloc;
						double ydist = gi.getYCenter() - yloc;
						double tpot = (xdist * xdist + ydist * ydist) / sigma2;
						tpot = gi.getPnumber() * Math.pow(Math.E, -tpot);
						pot += tpot;
						xdp += xdist * tpot;
						ydp += ydist * tpot;
					}
				}
				grids[x][y].setPotential(pot);
				grids[x][y].setXdp(xdp);
				grids[x][y].setYdp(ydp);
			}
		}
	}

	/**
	 * ȡΪgridXgridYھ
	 * 
	 * @param gridX
	 *            x
	 * @param gridY
	 *            y
	 * @return 
	 */
	private Grid[] getNeighborGrids(int gridX, int gridY) {
		LinkedList<Grid> result = new LinkedList<Grid>();

		if (gridX > 0)
			result.add(grids[gridX - 1][gridY]);
		if (gridY > 0)
			result.add(grids[gridX][gridY - 1]);
		if (gridX < K - 1)
			result.add(grids[gridX + 1][gridY]);
		if (gridY < K - 1)
			result.add(grids[gridX][gridY + 1]);

		Grid[] array = new Grid[result.size()];
		array = result.toArray(array);
		return array;
	}

	private class Coord {
		private int x;
		private int y;

		public Coord(int x, int y) {
			this.x = x;
			this.y = y;
		}

		public int getX() {
			return x;
		}

		public int getY() {
			return y;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + getOuterType().hashCode();
			result = prime * result + x;
			result = prime * result + y;
			return result;
		}

		@Override
		public boolean equals(Object obj) {
			if (this == obj)
				return true;
			if (obj == null)
				return false;
			if (getClass() != obj.getClass())
				return false;
			Coord other = (Coord) obj;
			if (!getOuterType().equals(other.getOuterType()))
				return false;
			if (x != other.x)
				return false;
			if (y != other.y)
				return false;
			return true;
		}

		private SNC2 getOuterType() {
			return SNC2.this;
		}

		@Override
		public String toString() {
			return "[x=" + x + ", y=" + y + "]";
		}

	}

	private class Grid {
		private double xall = 0;
		private double yall = 0;
		private double potential = -1;
		private double xdp = -1;
		private double ydp = -1;
		private int pnumber = 0;
		private ArrayList<DataPoint> list = new ArrayList<DataPoint>();

		public void addDataPoint(DataPoint point) {
			pnumber++;
			xall += point.getCoord_X();
			yall += point.getCoord_Y();
			list.add(point);
		}

		public void setCenter(double xloc, double yloc) {
			this.xall = xloc;
			this.yall = yloc;
		}

		public double getPotential() {
			return potential;
		}

		public void setPotential(double potential) {
			this.potential = potential;
		}

		public double getXdp() {
			return xdp;
		}

		public void setXdp(double xdp) {
			this.xdp = xdp;
		}

		public double getYdp() {
			return ydp;
		}

		public int getPnumber() {
			return pnumber;
		}

		public void setYdp(double ydp) {
			this.ydp = ydp;
		}

		public double getXCenter() {
			if (pnumber == 0)
				return xall;
			else
				return xall / pnumber;
		}

		public double getYCenter() {
			if (pnumber == 0)
				return yall;
			else
				return yall / pnumber;
		}
	}

	class SCluster {
		Coord center;
		Color color;
		int clusterNumber = 0;
		List<Coord> contentList = new LinkedList<Coord>();

		SCluster(int x, int y, int clusterNumber) {
			center = new Coord(x, y);
			color = Color.green;
			this.clusterNumber = clusterNumber;

			contentList.add(center);
			if (x > 0)
				contentList.add(new Coord(x - 1, y));
			if (x < K - 1)
				contentList.add(new Coord(x + 1, y));
			if (y > 0)
				contentList.add(new Coord(x, y - 1));
			if (y < K - 1)
				contentList.add(new Coord(x, y + 1));

		}

		void addGrid(int x, int y) {
			contentList.add(new Coord(x, y));
		}

		boolean containGrid(int x, int y) {
			Coord gridNumber = new Coord(x, y);
			return contentList.contains(gridNumber);
		}
	}
	
	private class StatisInfoDialog extends JDialog {
		private static final long serialVersionUID = 1L;

		private JTextField field;
				
		private int value=0;
		
		/**
		 * ½һԻ
		 * @param parent	Իӵ
		 * @param currentValue	ǰ趨ĳ
		 */
		public StatisInfoDialog(Frame parent, String msg){
			super(parent,true);
			
			GridBagLayout grid=new GridBagLayout();
			GridBagConstraints cons=new GridBagConstraints();
			setLayout(grid);
			
			setTitle("");
			
			JLabel pane=new JLabel(msg);
			pane.setSize(200, 250);
			cons.gridwidth=2;
			cons.gridheight=2;
			grid.setConstraints(pane, cons);
			add(pane);
					
			JLabel label2=new JLabel("ֵ = ", JLabel.CENTER);
			label2.setToolTipText("Ҳֵ");
			cons.gridx=0;
			cons.gridwidth=GridBagConstraints.RELATIVE;
			cons.gridheight=1;
			cons.insets=new Insets(0,5,0,5);
			grid.setConstraints(label2, cons);
			add(label2);
			
			cons.gridx=1;
			cons.gridwidth=GridBagConstraints.REMAINDER;
			cons.fill=GridBagConstraints.BOTH;
			field=new IntTextField(1);
			field.setToolTipText("ֵβ");
			field.setText("0");
			grid.setConstraints(field, cons);
			add(field);
			
			JButton confirm=new JButton("ȷ");
			confirm.setToolTipText("");
			confirm.addActionListener(new ConfirmListener());
			cons.fill=GridBagConstraints.NONE;
			cons.gridx=0;
			cons.gridwidth=GridBagConstraints.RELATIVE;
			grid.setConstraints(confirm, cons);
			add(confirm);
			
			JButton cancel=new JButton("ȡ");
			cancel.setToolTipText("ȡ");
			cancel.addActionListener(new CancelListener());
			cons.gridx=1;
			grid.setConstraints(cancel, cons);
			add(cancel);
			
			setDefaultCloseOperation(DISPOSE_ON_CLOSE);
			if(parent!=null){
				setLocationRelativeTo(parent);
				setLocation(parent.getWidth()/2, parent.getHeight()/2);
			}
			setSize(260, 230);
			setVisible(true);
		}

		public int getValue() {
			return value;
		}
		
		/**
		 * ȷť¼
		 * @author <a href="mailto:ethonchan@gmail.com">ethonchan</a>
		 *
		 */
		class ConfirmListener implements ActionListener{
			public void actionPerformed(ActionEvent e) {
				String str = field.getText();
				value=Integer.parseInt(str);
				StatisInfoDialog.this.setVisible(false);
			}
		}
		
		/**
		 * ȡť¼
		 * @author <a href="mailto:ethonchan@gmail.com">ethonchan</a>
		 *
		 */
		class CancelListener implements ActionListener{
			public void actionPerformed(ActionEvent e) {
				StatisInfoDialog.this.setVisible(false);
			}
		}
	}
}
